<?php

namespace Depicter\Document\Models\Elements;

use Averta\Core\Utility\Arr;
use Averta\Core\Utility\JSON;
use Depicter\Document\Models\Common\Styles;
use Depicter\Document\Models\Element;
use Depicter\Html\Html;

class Component extends Element
{

	/**
	 * Render arrow markup
	 *
	 * @return \TypeRocket\Html\Html|void
	 * @throws \JsonMapper_Exception
	 */
	public function render() {
		$args = $this->getDefaultAttributes();
		return Html::div( $args );
	}

	public function getDefaultAttributes(){
		$parentAttrs = parent::getDefaultAttributes(); // TODO: Change the autogenerated stub

		$options = $this->options;
		foreach( $options as $key => $option ) {
			if ( strpos( $key, 'imageAsset' ) ) {
				if ( is_object( $options->$key ) ) {
					$source = $this->hasDataSheet() ? $this->maybeReplaceDataSheetTags( $options->$key->src ) : $options->$key->src;
					$options->$key->srcset = \Depicter::media()->getSrcSet( $source );
					$options->$key->src = \Depicter::media()->getSourceUrl( $source );
				} else {
					// $option is string and is the src id of image asset
					$source = $this->hasDataSheet() ? $this->maybeReplaceDataSheetTags( $option ) : $option;
					$options->$key = \Depicter::media()->getSourceUrl( $source );
				}
			}
		}

		$componentProps = JSON::encode( $options );
		$componentProps = str_replace( ':imageAsset', '', $componentProps );

		$attrs = [
			'data-component-type' => $this->componentType,
			'data-component-props' => $componentProps
		];

		return Arr::merge( $attrs, $parentAttrs );
	}

	/**
	 * Get list of selector and CSS for element
	 *
	 * @return array
	 * @throws \JsonMapper_Exception
	 */
	public function getSelectorAndCssList(){
		$this->selectorCssList = parent::getSelectorAndCssList();

		$innerStyles = $this->prepare()->innerStyles;
		if ( !empty( $innerStyles ) ) {

			foreach( $innerStyles as $cssSelector => $styles ){
				if ( empty( $styles ) || ! $styles instanceof Styles ) {
					continue;
				}

				$generalCss = $innerStyles->{$cssSelector}->getGeneralCss('normal');
				// Add SVG selector and css
				$svgCss = $this->getSvgCss( $cssSelector );
				$this->selectorCssList[ '.' . $this->getStyleSelector() . ' .' . $this->camelCaseToHyphenated( $cssSelector ) ] = array_merge_recursive( $generalCss, $svgCss );
			}
		}

		return $this->selectorCssList;
	}

	/**
	 * change a string from camelCase style to hyphenated style
	 * @param $inputString
	 *
	 * @return string
	 */
	public function camelCaseToHyphenated( $inputString ) {
		$hyphenatedString = strtolower(preg_replace('/(?<!^)[A-Z]/', '-$0', $inputString));
		return $hyphenatedString;
	}

	/**
	 * Get styles of svg
	 *
	 * @return array|array[]
	 * @throws \JsonMapper_Exception
	 */
	protected function getSvgCss( $cssSelector ) {
		// Get styles list from styles property
		return ! empty( $this->innerStyles->{$cssSelector} ) ? $this->innerStyles->{$cssSelector}->getSvgCss() : [];
	}
}
