<?php

// This file is part of the Carrington JAM Theme for WordPress
// http://carringtontheme.com
//
// Copyright (c) 2008-2009 Crowd Favorite, Ltd. All rights reserved.
// http://crowdfavorite.com
//
// Released under the GPL license
// http://www.opensource.org/licenses/gpl-license.php
//
// **********************************************************************
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
// **********************************************************************

if (__FILE__ == $_SERVER['SCRIPT_FILENAME']) { die(); }
if (CFCT_DEBUG) { cfct_banner(__FILE__); }

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes() ?>>
<head profile="http://gmpg.org/xfn/11">
	<title><?php wp_title( '-', true, 'right' ); echo wp_specialchars( get_bloginfo('name'), 1 ); ?></title>
	<meta http-equiv="content-type" content="<?php bloginfo('html_type') ?>; charset=<?php bloginfo('charset') ?>" />

	<link rel="alternate" type="application/rss+xml" href="<?php bloginfo('rss2_url') ?>" title="<?php printf( __( '%s latest posts', 'carrington-jam' ), wp_specialchars( get_bloginfo('name'), 1 ) ) ?>" />
	<link rel="alternate" type="application/rss+xml" href="<?php bloginfo('comments_rss2_url') ?>" title="<?php printf( __( '%s latest comments', 'carrington-jam' ), wp_specialchars( get_bloginfo('name'), 1 ) ) ?>" />
	<link rel="pingback" href="<?php bloginfo('pingback_url') ?>" />
	<?php wp_get_archives('type=monthly&format=link'); ?>
	<link rel="stylesheet" type="text/css" media="screen" href="<?php bloginfo('stylesheet_url') ?>" />
	<link rel="stylesheet" type="text/css" media="screen" href="<?php bloginfo('template_directory') ?>/carrington-core/lightbox/css/thickbox.css" /> 
	<?php
	// Javascript for threaded comments
	if ( is_singular() ) { wp_enqueue_script( 'comment-reply' ); } ?>
<?php wp_enqueue_script('jquery'); ?>
<?php wp_head(); ?>
</head>

<body>
	<div id="top">
    <?php $before = "<span class=\"register\">"; $after = "</span> / <span class=\"login\"> "; ?>
		<?php wp_register( $before, $after ); ?>
		<?php wp_loginout(); ?></span>
		<?php wp_meta(); ?>
	</div>
<div id="wrapper">
<div id="header">
<a href="<?php bloginfo('url') ?>/" title="Home" rel="home"><span id="blog-title"><?php bloginfo('name') ?></span></a><br />
<p class="description"><?php bloginfo('description'); ?></p>
<a href="<?php bloginfo('rss2_url') ?>" title="RSS" class="rss">RSS</a>
<div id="bar">
<ul id="nav">
<li class="page_item page-item-1 <?php if ( is_home() ) { ?>current_page_item<?php } ?>"><a href="<?php echo get_settings('home'); ?>/" title="Back to Main Page">Home</a></li>
<?php wp_list_pages('sort_column=menu_order&depth=1&title_li');?>
</ul>
<?php cfct_form('search'); ?>
</div>
</div>
<div id="page">